;////////////////////////////////////////////////////////////////////////////////////////////////
;// Created by Soa's for atMega1280 chip in AVRStudio4 (111102)
;// for larger IO registers chip (greater than 64 IO registers)
;//
;// avr macro argument is in form of @0, @1, @2, ... ,@9
;// H = function/io/special register (io) higher than address 63
;//
;////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef AVR_GEN_02_ASM_INC
#define AVR_GEN_02_ASM_INC



;////////////////////////////////////////////////////////////////////////////////////////////////

.macro setValueWH;(addr) ;clock = 2
    lds W, @0
.endm

.macro setValueFH;(reg, addr) ;clock = 2
    lds @0, @1
.endm



.macro setValueHW;(addr) ;clock = 2
    sts @0, W
.endm

.macro setValueHL;(addr, val) ;clock = 2
    setValueWL @1
    sts @0, W
.endm

.macro setValueHF;(addr, reg) ;clock = 2
    sts @0, @1
.endm



;////////////////////////////////////////////////////////////////////////////////////////////////

.macro setBitH;(io, bit) ;clock = 5
    setValueWH @0
    setBitW @1
    setValueHW @0
.endm

.macro clearBitH;(io, bit) ;clock = 5
    setValueWH @0
    clearBitW @1
    setValueHW @0
.endm



;////////////////////////////////////////////////////////////////////////////////////////////////

.macro orValueHW;(io) ;clock = 5
    setValueFH var1, @0
    orValueFW var1, W
    setValueHF var1
.endm

.macro orValueHL;(io, val) ;clock = 5
    setValueWH @0
    orValueWL @1
    setValueHW @0
.endm

.macro orValueHF;(io, reg) ;clock = 5
    setValueWH @0
    orValueWF @1
    setValueHW @0
.endm



;////////////////////////////////////////////////////////////////////////////////////////////////

.macro andValueHW;(io) ;clock = 5
    setValueFH var1, @0
    andValueFW var1, W
    setValueHF var1
.endm

.macro andValueHL;(io, val) ;clock = 5
    setValueWH @0
    andValueWL @1
    setValueHW @0
.endm

.macro andValueHF;(io, reg) ;clock = 5
    setValueWH @0
    andValueWF @1
    setValueHW @0
.endm



;////////////////////////////////////////////////////////////////////////////////////////////////

.macro skipIfBitSetH;(io, bit) ;clock = 3 (not skip), 4/5 (skip)
    setValueWH @0
    skipIfBitSetW @1
.endm

.macro ifBitSetH;(io, bit, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfBitSetH @0, @1
    goto @2
.endm



#endif ;// AVR_GEN_02_ASM_INC
