;////////////////////////////////////////////////////////////////////////////////////////////////
;// Created by Soa's for atTiny13x chip in AVRStudio4 (111009)
;// based on and modified from pic_gen_01_asm.inc ver1
;//
;// avr macro argument is in form of @0, @1, @2, ... ,@9
;// W = temporary storage register (W)
;// L = literal/immediate value (val)
;// F = general purpose register (reg)
;// R = function/io/special register (io)
;// W and var1 must be defined in app library (for non microchip mcu)
;//
;////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef AVR_GEN_01_ASM_INC
#define AVR_GEN_01_ASM_INC

#define IO_OUTPUT 1
#define IO_INPUT 0

;for mult return value (r0 + r1) and temporary var for other function
.def var1 = r0
.def var2 = r1

;simulation of Microchip's temporary register W (must be within r16 - r31)
.def W = r25



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// microchip compatible opcode
;/////////////////////////////////////////////////////////////////////////////////////////////////

.macro return ;clock = 4/5
    ret
.endm

.macro retlw;(val) [W = val] ;clock = 5/6
    ldi W, @0
    return
.endm

.macro retfie ;clock = 4/5
    reti
.endm

.macro goto;(addr) ;clock = 2
    rjmp @0
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// data transfer
;/////////////////////////////////////////////////////////////////////////////////////////////////

.macro zeroValueW ;[W = 0] ;clock = 1
    clr W
.endm

.macro zeroValueF;(reg) [reg = 0] ;clock = 1
    clr @0
.endm

.macro zeroValueR;(io) [io = 0; W = 0] ;clock = 2
    zeroValueW
    out @0, W
.endm



.macro setValueWL;(val) [W = val] ;clock = 1
    ldi W, @0
.endm

.macro setValueWF;(reg) [W = reg] ;clock = 1
    mov W, @0
.endm

.macro setValueWR;(io) [W = io] ;clock = 1
    in W, @0
.endm

.macro setValueFW;(reg) [reg = W] ;clock = 1
    mov @0, W
.endm

.macro setValueFL;(reg, val) [reg = val] ;clock = 1
    ldi @0, @1
.endm

.macro setValueFF;(reg, reg2) [reg = reg2] ;clock = 1
    mov @0, @1
.endm

.macro setValueFR;(reg, io) [reg = io] ;clock = 1
    in @0, @1
.endm

.macro setValueRW;(io) [io = W] ;clock = 1
    out @0, W
.endm

.macro setValueRL;(io, val) [io = val] ;clock = 2
    setValueWL @1
    out @0, W
.endm

.macro setValueRF;(io, reg) [io = reg] ;clock = 1
    out @0, @1
.endm

.macro setValueRR;(io, io2) [io = io2] ;clock = 2
    setValueWR @1
    out @0, W
.endm



.macro setBitW;(bit) ;clock = 1
    sbr W, (1 << @0)
.endm

.macro setBitF;(reg, bit) ;clock = 1
    sbr @0, (1 << @1)
.endm

.macro setBitR;(io, bit) ;clock = 2
    sbi @0, @1
.endm



.macro clearBitW;(bit) ;clock = 1
    cbr W, (1 << @0)
.endm

.macro clearBitF;(reg, bit) ;clock = 1
    cbr @0, (1 << @1)
.endm

.macro clearBitR;(io, bit) ;clock = 2
    cbi @0, @1
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// status and arithmetic
;/////////////////////////////////////////////////////////////////////////////////////////////////

.macro setCarry ;clock = 1
    sec
.endm

.macro clearCarry ;clock = 1
    clc
.endm



.macro rotateLeftW ;[rotate left W through carry @ rlf] ;clock = 1
    rol W
.endm

.macro rotateLeftF;(reg) [rotate left reg through carry @ rlf] ;clock = 1
    rol @0
.endm

.macro rotateLeftR;(io) [rotate left io through carry @ rlf] ;clock = 3
    setValueWR @0
    rotateLeftW
    setValueRW @0
.endm



.macro rotateRightW ;[rotate right W through carry @ rrf] ;clock = 1
    ror W
.endm

.macro rotateRightF;(reg) [rotate right reg through carry @ rrf] ;clock = 1
    ror @0
.endm

.macro rotateRightR;(io) [rotate right io through carry @ rrf] ;clock = 3
    setValueWR @0
    rotateRightW
    setValueRW @0
.endm



.macro shiftLeftW ;[logical rotate left, W *= 2] ;clock = 1
    lsl W
.endm

.macro shiftLeftF;(reg) [logical rotate left, reg *= 2] ;clock = 1
    lsl @0
.endm

.macro shiftLeftR;(io) [logical rotate left, io *= 2] ;clock = 3
    setValueWR @0
    shiftLeftW
    setValueRW @0
.endm



.macro shiftRightW ;[logical rotate right, W /= 2] ;clock = 1
    lsr W
.endm

.macro shiftRightF;(reg) [logical rotate right, reg /= 2] ;clock = 1
    lsr @0
.endm

.macro shiftRightR;(io) [logical rotate right, io /= 2] ;clock = 3
    setValueWR @0
    shiftRightW
    setValueRW @0
.endm



.macro swapNibbleW ;clock = 1
    swap W
.endm

.macro swapNibbleF;(reg) ;clock = 1
    swap @0
.endm

.macro swapNibbleR;(io) ;clock = 3
    setValueWR @0
    swapNibbleW
    setValueRW @0
.endm



.macro addValueWL;(val) [W += val] ;clock = 2
    setValueFL var1, @0
    add W, var1
.endm

.macro addValueWF;(reg) [W += reg] ;clock = 1
    add W, @0
.endm

.macro addValueWR;(io) [W += io] ;clock = 2
    setValueFR var1, @0
    add W, var1
.endm

.macro addValueFW;(reg) [reg += W] ;clock = 1
    add @0, W
.endm

.macro addValueFL;(reg, val) [reg += val; W = val] ;clock = 2
    setValueWL @1
    add @0, W
.endm

.macro addValueFF;(reg, reg2) [reg += reg2] ;clock = 1
    add @0, @1
.endm

.macro addValueFR;(reg, io) [reg += io; W = io] ;clock = 2
    setValueWR @1
    addValueFW @0
.endm

.macro addValueRW;(io) [io += W] ;clock = 3
    setValueFR var1, @0
    addValueFW var1
    setValueRF @0, var1
.endm

.macro addValueRL;(io, val) [io += val; W = io] ;clock = 4
    setValueWR @0
    addValueWL @1
    setValueRW @0
.endm

.macro addValueRF;(io, reg) [io += reg; W = io] ;clock = 3
    setValueWR @0
    addValueWF @1
    setValueRW @0
.endm

.macro addValueRR;(io, io2) [io += io2; W = io] ;clock = 4
    setValueWR @1
    addValueRW @0
.endm



.macro subValueWL;(val) [W -= val] ;clock = 1
    subi W, @0
.endm

.macro subValueWF;(reg) [W -= reg] ;clock = 1
    sub W, @0
.endm

.macro subValueWR;(io) [W -= io] ;clock = 2
    setValueFR var1, @0
    subValueWF var1
.endm

.macro subValueFW;(reg) [reg -= W] ;clock = 1
    sub @0, W
.endm

.macro subValueFL;(reg, val) [reg -= val] ;clock = 1
    subi @0, @1
.endm

.macro subValueFF;(reg, reg2) [reg -= reg2] ;clock = 1
    sub @0, @1
.endm

.macro subValueFR;(reg, io) [reg -= io; W = io] ;clock = 2
    setValueWR @1
    subValueFW @0
.endm

.macro subValueRW;(io) [io -= W] ;clock = 3
    setValueFR var1, @0
    subValueFW var1
    setValueRF @0, var1
.endm

.macro subValueRL;(io, val) [io -= val; W = io] ;clock = 3
    setValueWR @0
    subValueWL @1
    setValueRW @0
.endm

.macro subValueRF;(io, reg) [io -= reg; W = io] ;clock = 3
    setValueWR @0
    subValueWF @1
    setValueRW @0
.endm

.macro subValueRR;(io, io2) [io -= io2; W = io] ;clock = 4
    setValueWR @0
    subValueWR @1
    setValueRW @0
.endm



.macro andValueWL;(val) [W &= val] ;clock = 1
    andi W, @0
.endm

.macro andValueWF;(reg) [W &= reg] ;clock = 1
    and W, @0
.endm

.macro andValueWR;(io) [W &= io] ;clock = 2
    setValueFR var1, @0
    and W, var1
.endm

.macro andValueFW;(reg) [reg &= W] ;clock = 1
    and @0, W
.endm

.macro andValueFL;(reg, val) [reg &= val] ;clock = 1
    andi @0, @1
.endm

.macro andValueFF;(reg, reg2) [reg &= reg2] ;clock = 1
    and @0, @1
.endm

.macro andValueFR;(reg, io) [reg &= io; W = io] ;clock = 2
    setValueWR @1
    andValueFW @0
.endm

.macro andValueRW;(io) [io &= W] ;clock = 3
    setValueFR var1, @0
    andValueFW var1
    setValueRF @0, var1
.endm

.macro andValueRL;(io, val) [io &= val; W = io] ;clock = 3
    setValueWR @0
    andValueWL @1
    setValueRW @0
.endm

.macro andValueRF;(io, reg) [io &= reg; W = io] ;clock = 3
    setValueWR @0
    andValueWF @1
    setValueRW @0
.endm

.macro andValueRR;(io, io2) [io &= io2; W = io] ;clock = 4
    setValueWR @0
    andValueWR @1
    setValueRW @0
.endm



.macro orValueWL;(val) [W |= val] ;clock = 1
    ori W, @0
.endm

.macro orValueWF;(reg) [W |= reg] ;clock = 1
    or W, @0
.endm

.macro orValueWR;(io) [W |= io] ;clock = 2
    setValueFR var1, @0
    or W, var1
.endm

.macro orValueFW;(reg) [reg |= W] ;clock = 1
    or @0, W
.endm

.macro orValueFL;(reg, val) [reg |= val] ;clock = 1
    ori @0, @1
.endm

.macro orValueFF;(reg, reg2) [reg |= reg2] ;clock = 1
    or @0, @1
.endm

.macro orValueFR;(reg, io) [reg |= io; W = io] ;clock = 2
    setValueWR @1
    orValueFW @0
.endm

.macro orValueRW;(io) [io |= W] ;clock = 3
    setValueFR var1, @0
    orValueFW var1
    setValueRF @0, var1
.endm

.macro orValueRL;(io, val) [io |= val; W = io] ;clock = 3
    setValueWR @0
    orValueWL @1
    setValueRW @0
.endm

.macro orValueRF;(io, reg) [io |= reg; W = io] ;clock = 3
    setValueWR @0
    orValueWF @1
    setValueRW @0
.endm

.macro orValueRR;(io, io2) [io |= io2; W = io] ;clock = 4
    setValueWR @0
    orValueWR @1
    setValueRW @0
.endm



.macro xorValueWL;(val) [W xor= val] ;clock = 2
    setValueFL var1, @0
    eor W, var1
.endm

.macro xorValueWF;(reg) [W xor= reg] ;clock = 1
    eor W, @0
.endm

.macro xorValueWR;(io) [W xor= io] ;clock = 2
    setValueFR var1, @0
    eor W, var1
.endm

.macro xorValueFW;(reg) [reg xor= W] ;clock = 1
    eor @0, W
.endm

.macro xorValueFL;(reg, val) [reg xor= val; W = val] ;clock = 2
    setValueWL @1
    eor @0, W
.endm

.macro xorValueFF;(reg, reg2) [reg xor= reg2] ;clock = 1
    eor @0, @1
.endm

.macro xorValueFR;(reg, io) [reg xor= io; W = io] ;clock = 2
    setValueWR @1
    xorValueFW @0
.endm

.macro xorValueRW;(io) [io xor= W] ;clock = 3
    setValueFR var1, @0
    xorValueFW var1
    setValueRF @0, var1
.endm

.macro xorValueRL;(io, val) [io xor= val; W = io] ;clock = 3
    setValueWR @0
    xorValueWL @1
    setValueRW @0
.endm

.macro xorValueRF;(io, reg) [io xor= reg; W = io] ;clock = 3
    setValueWR @0
    xorValueWF @1
    setValueRW @0
.endm

.macro xorValueRR;(io, io2) [io xor= io2; W = io] ;clock = 4
    setValueWR @0
    xorValueWR @1
    setValueRW @0
.endm



.macro incValueW ;[W += 1] ;clock = 1
    inc W
.endm

.macro incValueF;(reg) [reg += 1] ;clock = 1
    inc @0
.endm

.macro incValueR;(io) [io += 1] ;clock = 3
    setValueWR @0
    incValueW
    setValueRW @0
.endm



.macro decValueW ;[W -= 1] ;clock = 1
    dec W
.endm

.macro decValueF;(reg) [reg -= 1] ;clock = 1
    dec @0
.endm

.macro decValueR;(io) [io -= 1] ;clock = 3
    setValueWR @0
    decValueW
    setValueRW @0
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// bit test branching
;/////////////////////////////////////////////////////////////////////////////////////////////////

.macro skipIfBitSetW;(bit) ;clock = 1 (not skip), 2/3 (skip)
    sbrs W, @0
.endm

.macro skipIfBitSetF;(reg, bit) ;clock = 1 (not skip), 2/3 (skip)
    sbrs @0, @1
.endm

.macro skipIfBitSetR;(io, bit) ;clock = 1 (not skip), 2/3 (skip)
    sbis @0, @1
.endm



.macro ifBitSetW;(bit, if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfBitSetW @0
    goto @1
.endm

.macro ifBitSetF;(reg, bit, if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfBitSetF @0, @1
    goto @2
.endm

.macro ifBitSetR;(io, bit, if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfBitSetR @0, @1
    goto @2
.endm



.macro skipIfBitClearW;(bit) ;clock = 1 (not skip), 2/3 (skip)
    sbrc W, @0
.endm

.macro skipIfBitClearF;(reg, bit) ;clock = 1 (not skip), 2/3 (skip)
    sbrc @0, @1
.endm

.macro skipIfBitClearR;(io, bit) ;clock = 1 (not skip), 2/3 (skip)
    sbic @0, @1
.endm



.macro ifBitClearW;(bit, if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfBitClearW @0
    goto @1
.endm

.macro ifBitClearF;(reg, bit, if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfBitClearF @0, @1
    goto @2
.endm

.macro ifBitClearR;(io, bit, if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfBitClearR @0, @1
    goto @2
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// status register branching
;/////////////////////////////////////////////////////////////////////////////////////////////////

.macro skipIfOverFlow ;[result overflow] ;clock = 1 (not skip), 2 (skip)
    brvs (PC+2)
.endm

.macro skipIfUnderFlow ;[result not overflow] ;clock = 1 (not skip), 2 (skip)
    brvc (PC+2)
.endm

.macro skipIfZero ;[result zero] ;clock = 1 (not skip), 2 (skip)
    brbs SREG_Z, (PC+2)
.endm

.macro skipIfNez ;[result not zero] ;clock = 1 (not skip), 2 (skip)
    brbc SREG_Z, (PC+2) 
.endm

.macro skipIfNeg ;[result negative] ;clock = 1 (not skip), 2 (skip)
    brbs SREG_C, (PC+2)
.endm

.macro skipIfPos ;[result positive] ;clock = 1 (not skip), 2 (skip)
    brbc SREG_C, (PC+2)
.endm



.macro ifOverFlow;(if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfOverFlow
    goto @0
.endm

.macro ifUnderFlow;(if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfUnderFlow
    goto @0
.endm

.macro ifZero;(if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfZero
    goto @0
.endm

.macro ifNez;(if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfNez
    goto @0
.endm

.macro ifNeg;(if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfNeg
    goto @0
.endm

.macro ifPos;(if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfPos
    goto @0
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// register and literal/immediate branching
;/////////////////////////////////////////////////////////////////////////////////////////////////

.macro skipIfEvenW ;clock = 1 (not skip), 2/3 (skip)
    sbrc W, 0
.endm

.macro skipIfEvenF;(reg) ;clock = 1 (not skip), 2/3 (skip)
    sbrc @0, 0
.endm

.macro skipIfEvenR;(io) ;clock = 2 (not skip), 3/4 (skip)
    setValueWR @0
    skipIfEvenW
.endm



.macro ifEvenW;(if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfEvenW
    goto @0
.endm

.macro ifEvenF;(reg, if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfEvenF @0
    goto @1
.endm

.macro ifEvenR;(io, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfEvenR @0
    goto @1
.endm



.macro skipIfOddW ;clock = 1 (not skip), 2/3 (skip)
    sbrs W, 0
.endm

.macro skipIfOddF;(reg) ;clock = 1 (not skip), 2/3 (skip)
    sbrs @0, 0
.endm

.macro skipIfOddR;(io) ;clock = 2 (not skip), 3/4 (skip)
    setValueWR @0
    skipIfOddW
.endm



.macro ifOddW;(if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfOddW
    goto @0
.endm

.macro ifOddF;(reg, if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfOddF @0
    goto @1
.endm

.macro ifOddR;(io, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfOddR @0
    goto @1
.endm



.macro skipIfZeroW ;clock = 2 (not skip), 3 (skip)
    tst W
    skipIfZero
.endm

.macro skipIfZeroF;(reg) ;clock = 2 (not skip), 3 (skip)
    tst @0
    skipIfZero
.endm

.macro skipIfZeroR;(io) ;clock = 3 (not skip), 4 (skip)
    setValueWR @0
    skipIfZeroW
.endm



.macro ifZeroW;(if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfZeroW
    goto @0
.endm

.macro ifZeroF;(reg, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfZeroF @0
    goto @1
.endm

.macro ifZeroR;(io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfZeroR @0
    goto @1
.endm



.macro skipIfNezW ;clock = 2 (not skip), 3 (skip)
    tst W
    skipIfNez
.endm

.macro skipIfNezF;(reg) ;clock = 2 (not skip), 3 (skip)
    tst @0
    skipIfNez
.endm

.macro skipIfNezR;(io) ;clock = 3 (not skip), 4 (skip)
    setValueWR @0
    skipIfNezW
.endm



.macro ifNezW;(if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfNezW
    goto @0
.endm

.macro ifNezF;(reg, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfNezF @0
    goto @1
.endm

.macro ifNezR;(io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfNezR @0
    goto @1
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// skip if less

.macro skipIfLessLW;(val) ;clock = 3 (not skip), 4 (skip)
    setValueFL var1, @0
    cp var1, W
    skipIfNeg
.endm

.macro skipIfLessLL;(val, val2) ;clock = 3 (not skip), 4 (skip)
    setValueWL @0
    cpi W, @1
    skipIfNeg
.endm

.macro skipIfLessLF;(val, reg) ;clock = 3 (not skip), 4 (skip)
    setValueFL var1, @0
    cp var1, @1
    skipIfNeg
.endm

.macro skipIfLessLR;(val, io) ;clock = 4 (not skip), 5 (skip)
    setValueWR @1
    skipIfLessLW @0
.endm

.macro skipIfLessWL;(val) ;clock = 2 (not skip), 3 (skip)
    cpi W, @0
    skipIfNeg
.endm

.macro skipIfLessWF;(reg) ;clock = 2 (not skip), 3 (skip)
    cp W, @0
    skipIfNeg
.endm

.macro skipIfLessWR;(io) ;clock = 3 (not skip), 4 (skip)
    setValueFR var1, @0
    skipIfLessWF var1
.endm

.macro skipIfLessFW;(reg) ;clock = 2 (not skip), 3 (skip)
    cp @0, W
    skipIfNeg
.endm

.macro skipIfLessFL;(reg, val) ;clock = 2 (not skip), 3 (skip)
    cpi @0, @1
    skipIfNeg
.endm

.macro skipIfLessFF;(reg, reg2) ;clock = 2 (not skip), 3 (skip)
    cp @0, @1
    skipIfNeg
.endm

.macro skipIfLessFR;(reg, io) ;clock = 3 (not skip), 4 (skip)
    setValueWR @1
    skipIfLessFW @0
.endm

.macro skipIfLessRW;(io) ;clock = 3 (not skip), 4 (skip)
    setValueFR var1, @0
    skipIfLessFW var1
.endm

.macro skipIfLessRL;(io, val) ;clock = 3 (not skip), 4 (skip)
    setValueWR @0
    skipIfLessWL @1
.endm

.macro skipIfLessRF;(io, reg) ;clock = 3 (not skip), 4 (skip)
    setValueWR @0
    skipIfLessWF @1
.endm

.macro skipIfLessRR;(io, io2) ;clock = 4 (not skip), 5 (skip)
    setValueWR @0
    skipIfLessWR @1
.endm



.macro ifLessLW;(val, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfLessLW @0
    goto @1
.endm

.macro ifLessLL;(val, val2, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfLessLL @0, @1
    goto @2
.endm

.macro ifLessLF;(val, reg, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfLessLF @0, @1
    goto @2
.endm

.macro ifLessLR;(val, io, if_not_lbl) ;clock = 5 (true), 6 (false)
    skipIfLessLR @0, @1
    goto @2
.endm

.macro ifLessWL;(val, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfLessWL @0
    goto @1
.endm

.macro ifLessWF;(reg, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfLessWF @0
    goto @1
.endm

.macro ifLessWR;(io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfLessWR @0
    goto @1
.endm

.macro ifLessFW;(reg, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfLessFW @0
    goto @1
.endm

.macro ifLessFL;(reg, val, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfLessFL @0, @1
    goto @2
.endm

.macro ifLessFF;(reg, reg2, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfLessFF @0, @1
    goto @2
.endm

.macro ifLessFR;(reg, io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfLessFR @0, @1
    goto @2
.endm

.macro ifLessRW;(io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfLessRW @0
    goto @1
.endm

.macro ifLessRL;(io, val, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfLessRL @0, @1
    goto @2
.endm

.macro ifLessRF;(io, reg, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfLessRF @0, @1
    goto @2
.endm

.macro ifLessRR;(io, io2, if_not_lbl) ;clock = 5 (true), 6 (false)
    skipIfLessRR @0, @1
    goto @2
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// skip if greater or equal

.macro skipIfGrEqLW;(val) ;clock = 3 (not skip), 4 (skip)
    setValueFL var1, @0
    cp var1, W
    skipIfPos
.endm

.macro skipIfGrEqLL;(val, val2) ;clock = 3 (not skip), 4 (skip)
    setValueWL @0
    cpi W, @1
    skipIfPos
.endm

.macro skipIfGrEqLF;(val, reg) ;clock = 3 (not skip), 4 (skip)
    setValueFL var1, @0
    cp var1, @1
    skipIfPos
.endm

.macro skipIfGrEqLR;(val, io) ;clock = 4 (not skip), 5 (skip)
    setValueWR @1
    skipIfGrEqLW @0
.endm

.macro skipIfGrEqWL;(val) ;clock = 2 (not skip), 3 (skip)
    cpi W, @0
    skipIfPos
.endm

.macro skipIfGrEqWF;(reg) ;clock = 2 (not skip), 3 (skip)
    cp W, @0
    skipIfPos
.endm

.macro skipIfGrEqWR;(io) ;clock = 3 (not skip), 4 (skip)
    setValueFR var1, @0
    skipIfGrEqWF var1
.endm

.macro skipIfGrEqFW;(reg) ;clock = 2 (not skip), 3 (skip)
    cp @0, W
    skipIfPos
.endm

.macro skipIfGrEqFL;(reg, val) ;clock = 2 (not skip), 3 (skip)
    cpi @0, @1
    skipIfPos
.endm

.macro skipIfGrEqFF;(reg, reg2) ;clock = 2 (not skip), 3 (skip)
    cp @0, @1
    skipIfPos
.endm

.macro skipIfGrEqFR;(reg, io) ;clock = 3 (not skip), 4 (skip)
    setValueWR @1
    skipIfGrEqFW @0
.endm

.macro skipIfGrEqRW;(io) ;clock = 3 (not skip), 4 (skip)
    setValueFR var1, @0
    skipIfGrEqFW var1
.endm

.macro skipIfGrEqRL;(io, val) ;clock = 3 (not skip), 4 (skip)
    setValueWR @0
    skipIfGrEqWL @1
.endm

.macro skipIfGrEqRF;(io, reg) ;clock = 3 (not skip), 4 (skip)
    setValueWR @0
    skipIfGrEqWF @1
.endm

.macro skipIfGrEqRR;(io, io2) ;clock = 4 (not skip), 5 (skip)
    setValueWR @0
    skipIfGrEqWR @1
.endm



.macro ifGrEqLW;(val, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfGrEqLW @0
    goto @1
.endm

.macro ifGrEqLL;(val, val2, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfGrEqLL @0, @1
    goto @2
.endm

.macro ifGrEqLF;(val, reg, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfGrEqLF @0, @1
    goto @2
.endm

.macro ifGrEqLR;(val, io, if_not_lbl) ;clock = 5 (true), 6 (false)
    skipIfGrEqLR @0, @1
    goto @2
.endm

.macro ifGrEqWL;(val, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfGrEqWL @0
    goto @1
.endm

.macro ifGrEqWF;(reg, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfGrEqWF @0
    goto @1
.endm

.macro ifGrEqWR;(io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfGrEqWR @0
    goto @1
.endm

.macro ifGrEqFW;(reg, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfGrEqFW @0
    goto @1
.endm

.macro ifGrEqFL;(reg, val, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfGrEqFL @0, @1
    goto @2
.endm

.macro ifGrEqFF;(reg, reg2, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfGrEqFF @0, @1
    goto @2
.endm

.macro ifGrEqFR;(reg, io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfGrEqFR @0, @1
    goto @2
.endm

.macro ifGrEqRW;(io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfGrEqRW @0
    goto @1
.endm

.macro ifGrEqRL;(io, val, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfGrEqRL @0, @1
    goto @2
.endm

.macro ifGrEqRF;(io, reg, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfGrEqRF @0, @1
    goto @2
.endm

.macro ifGrEqRR;(io, io2, if_not_lbl) ;clock = 5 (true), 6 (false)
    skipIfGrEqRR @0, @1
    goto @2
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// skip if equal

.macro skipIfEquLW;(val) ;clock = 2 (not skip), 3 (skip)
    cpi W, @0
    skipIfZero
.endm

.macro skipIfEquLL;(val, val2) ;clock = 3 (not skip), 4 (skip)
    setValueWL @1
    skipIfEquLW @0
.endm

.macro skipIfEquLF;(val, reg) ;clock = 2 (not skip), 3 (skip)
    cpi @1, @0
    skipIfZero
.endm

.macro skipIfEquLR;(val, io) ;clock = 3 (not skip), 4 (skip)
    setValueWR @1
    skipIfEquLW @0
.endm

.macro skipIfEquWF;(reg) ;clock = 1 (not skip), 2/3 (skip)
    cpse W, @0
.endm

.macro skipIfEquWR;(io) ;clock = 2 (not skip), 3/4 (skip)
    setValueFR var1
    cpse W, var1
.endm

.macro skipIfEquFL;(reg, val) ;clock = 2 (not skip), 3 (skip)
    cpi @0, @1
    skipIfZero
.endm

.macro skipIfEquFF;(reg, reg2) ;clock = 1 (not skip), 2/3 (skip)
    cpse @0, @1
.endm

.macro skipIfEquFR;(reg, io) ;clock = 2 (not skip), 3/4 (skip)
    setValueWR @1
    skipIfEquFW @0
.endm

.macro skipIfEquRL;(io, val) ;clock = 3 (not skip), 4 (skip)
    setValueWR @0
    skipIfEquWL val
.endm

.macro skipIfEquRF;(io, reg) ;clock = 2 (not skip), 3/4 (skip)
    setValueWR @0
    cpse W, @1
.endm

.macro skipIfEquRR;(io, io2) ;clock = 3 (not skip), 4/5 (skip)
    setValueWR @0
    setValueFR var1, @1
    cpse W, var1
.endm

#define skipIfEquWL skipIfEquLW
#define skipIfEquFW skipIfEquWF
#define skipIfEquRW skipIfEquWR



.macro ifEquLW;(val, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfEquLW @0
    goto @1
.endm

.macro ifEquLL;(val, val2, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfEquLL @0, @1
    goto @2
.endm

.macro ifEquLF;(val, reg, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfEquLF @0, @1
    goto @2
.endm

.macro ifEquLR;(val, io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfEquLR @0, @1
    goto @2
.endm

.macro ifEquWF;(reg, if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfEquWF @0
    goto @1
.endm

.macro ifEquWR;(io, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfEquWR @0
    goto @1
.endm

.macro ifEquFL;(reg, val, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfEquFL @0, @1
    goto @2
.endm

.macro ifEquFF;(reg, reg2, if_not_lbl) ;clock = 2 (true), 3 (false)
    skipIfEquFF @0, @1
    goto @2
.endm

.macro ifEquFR;(reg, io, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfEquFR @0, @1
    goto @2
.endm

.macro ifEquRL;(io, val, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfEquRL @0, @1
    goto @2
.endm

.macro ifEquRF;(io, reg, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfEquRF @0, @1
    goto @2
.endm

.macro ifEquRR;(io, io2, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfEquRR @0, @1
    goto @2
.endm

#define ifEquWL ifEquLW
#define ifEquFW ifEquWF
#define ifEquRW ifEquWR



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// skip if not equal

.macro skipIfNeqLW;(val) ;clock = 2 (not skip), 3 (skip)
    cpi W, @0
    skipIfNez
.endm

.macro skipIfNeqLL;(val, val2) ;clock = 3 (not skip), 4 (skip)
    setValueWL @1
    skipIfNeqLW @0
.endm

.macro skipIfNeqLF;(val, reg) ;clock = 2 (not skip), 3 (skip)
    cpi @1, @0
    skipIfNez
.endm

.macro skipIfNeqLR;(val, io) ;clock = 3 (not skip), 4 (skip)
    setValueWR @1
    skipIfNeqLW @0
.endm

.macro skipIfNeqWF;(reg) ;clock = 2 (not skip), 3 (skip)
    cp W, @0
    skipIfNez
.endm

.macro skipIfNeqWR;(io) ;clock = 3 (not skip), 4 (skip)
    setValueFR var1, @0
    skipIfNeqWF var1
.endm

.macro skipIfNeqFL;(reg, val) ;clock = 2 (not skip), 3 (skip)
    cpi @0, @1
    skipIfNez
.endm

.macro skipIfNeqFF;(reg, reg2) ;clock = 2 (not skip), 3 (skip)
    cp @0, @1
    skipIfNez
.endm

.macro skipIfNeqFR;(reg, io) ;clock = 3 (not skip), 4 (skip)
    setValueWR @1
    skipIfNeqFW @0
.endm

.macro skipIfNeqRL;(io, val) ;clock = 3 (not skip), 4 (skip)
    setValueWR @0
    cpi W, @1
    skipIfNez
.endm

.macro skipIfNeqRF;(io, reg) ;clock = 3 (not skip), 4 (skip)
    setValueWR @0
    cp W, @1
    skipIfNez
.endm

.macro skipIfNeqRR;(io, io2) ;clock = 4 (not skip), 5 (skip)
    setValueWR @0
    setValueFR var1, @1
    skipIfNeqWF var1
.endm

#define skipIfNeqWL skipIfNeqLW
#define skipIfNeqFW skipIfNeqWF
#define skipIfNeqRW skipIfNeqWR



.macro ifNeqLW;(val, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfNeqLW @0
    goto @1
.endm

.macro ifNeqLL;(val, val2, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfNeqLL @0, @1
    goto @2
.endm

.macro ifNeqLF;(val, reg, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfNeqLF @0, @1
    goto @2
.endm

.macro ifNeqLR;(val, io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfNeqLR @0, @1
    goto @2
.endm

.macro ifNeqWF;(reg, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfNeqWF @0
    goto @1
.endm

.macro ifNeqWR;(io, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfNeqWR @0
    goto @1
.endm

.macro ifNeqFL;(reg, val, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfNeqFL @0, @1
    goto @2
.endm

.macro ifNeqFF;(reg, reg2, if_not_lbl) ;clock = 3 (true), 4 (false)
    skipIfNeqFF @0, @1
    goto @2
.endm

.macro ifNeqFR;(reg, io, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfNeqFR @0, @1
    goto @2
.endm

.macro ifNeqRL;(io, val, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfNeqRL @0, @1
    goto @2
.endm

.macro ifNeqRF;(io, reg, if_not_lbl) ;clock = 4 (true), 5 (false)
    skipIfNeqRF @0, @1
    goto @2
.endm

.macro ifNeqRR;(io, io2, if_not_lbl) ;clock = 5 (true), 6 (false)
    skipIfNeqRR @0, @1
    goto @2
.endm

#define ifNeqWL ifNeqLW
#define ifNeqFW ifNeqWF
#define ifNeqRW ifNeqWR



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// pointer functions
;/////////////////////////////////////////////////////////////////////////////////////////////////

/* NOT IMPLEMENTED YET UNTIL NEEDED
setPtr macro reg ;clock = 2
assignPtrL macro val ;clock = 2
assignPtrF macro reg ;clock = 2
assignPtrW macro ;clock = 1
incPtr macro ;clock = 1
decPtr macro ;clock = 1
*/



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// loop functions
;/////////////////////////////////////////////////////////////////////////////////////////////////

;for (reg = sta; reg < end; reg += step)
;repeat_lbl must be present after this forFL/FF macro

.macro forFL;(reg, val)
    setValueFL @0, @1
.endm

.macro forFF;(reg, reg2)
    setValueFF @0, @1
.endm

;for (reg = sta; reg < end; reg += step)
;repeat_lbl must be present just after forFL/FF macro

.macro nextFLL;(reg, enn, step, repeat_lbl)

    ;next step and overflow quit
    addValueFL @0, @2
    skipIfUnderFlow
    goto (PC+5)

    cpi @0, @1 ;skipIfLessL reg, enn
    brbs SREG_N, (PC+2) ;result negative

    ;quit or repeat loop
    goto (PC+2)
    goto @3
.endm

.macro nextFLF;(reg, enn, step, repeat_lbl)

    ;next step and overflow quit
    addValueFF @0, @2
    skipIfUnderFlow
    goto (PC+5)

    cpi @0, @1 ;skipIfLessL reg, enn
    brbs SREG_N, (PC+2) ;result negative

    ;quit or repeat loop
    goto (PC+2)
    goto @3
.endm

.macro nextFFL;(reg, enn, step, repeat_lbl)

    ;next step and overflow quit
    addValueFL @0, @2
    skipIfUnderFlow
    goto (PC+5)

    cp @0, @1 ;skipIfLessF reg, enn
    brbs SREG_N, (PC+2) ;result negative

    ;quit or repeat loop
    goto (PC+2)
    goto @3
.endm

.macro nextFFF;(reg, enn, step, repeat_lbl)

    ;next step and overflow quit
    addValueFF @0, @2
    skipIfUnderFlow
    goto (PC+5)

    cp @0, @1 ;skipIfLessF reg, enn
    brbs SREG_N, (PC+2) ;result negative

    ;quit or repeat loop
    goto (PC+2)
    goto @3
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// delay/time functions
;/////////////////////////////////////////////////////////////////////////////////////////////////

;halting processor
.macro stop
    goto PC
.endm



#endif ;// AVR_GEN_01_ASM_INC
