;/////////////////////////////////////////////////////////////////////////////////////////////////
;// Created by Soa's System for atMega640/1280/1281/2560/2561 chip in AVRStudio4 (111102)
;//
;/////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef AVR_ATMEGA1280_ASM_INC
#define AVR_ATMEGA1280_ASM_INC

;set in project/assembler option for soa's library path
.include "m1280def.inc"
.include "avr_gen_01_asm.inc"
.include "avr_gen_02_asm.inc"



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// initialization code
;/////////////////////////////////////////////////////////////////////////////////////////////////

;set memory to proper address
.DSEG
.org    SRAM_START
.CSEG



/***** INTERRUPT VECTORS LIST TO BE ADDED AS NECESSARY *******************************************
.equ	INT0addr	= 0x0002	; External Interrupt Request 0
.equ	INT1addr	= 0x0004	; External Interrupt Request 1
.equ	INT2addr	= 0x0006	; External Interrupt Request 2
.equ	INT3addr	= 0x0008	; External Interrupt Request 3
.equ	INT4addr	= 0x000a	; External Interrupt Request 4
.equ	INT5addr	= 0x000c	; External Interrupt Request 5
.equ	INT6addr	= 0x000e	; External Interrupt Request 6
.equ	INT7addr	= 0x0010	; External Interrupt Request 7
.equ	PCI0addr	= 0x0012	; Pin Change Interrupt Request 0
.equ	PCI1addr	= 0x0014	; Pin Change Interrupt Request 1
.equ	PCI2addr	= 0x0016	; Pin Change Interrupt Request 2
.equ	WDTaddr		= 0x0018	; Watchdog Time-out Interrupt
.equ	OC2Aaddr	= 0x001a	; Timer/Counter2 Compare Match A
.equ	OC2Baddr	= 0x001c	; Timer/Counter2 Compare Match B
.equ	OVF2addr	= 0x001e	; Timer/Counter2 Overflow
.equ	ICP1addr	= 0x0020	; Timer/Counter1 Capture Event
.equ	OC1Aaddr	= 0x0022	; Timer/Counter1 Compare Match A
.equ	OC1Baddr	= 0x0024	; Timer/Counter1 Compare Match B
.equ	OC1Caddr	= 0x0026	; Timer/Counter1 Compare Match C
.equ	OVF1addr	= 0x0028	; Timer/Counter1 Overflow
.equ	OC0Aaddr	= 0x002a	; Timer/Counter0 Compare Match A
.equ	OC0Baddr	= 0x002c	; Timer/Counter0 Compare Match B
.equ	OVF0addr	= 0x002e	; Timer/Counter0 Overflow
.equ	SPIaddr		= 0x0030	; SPI Serial Transfer Complete
.equ	ACIaddr		= 0x0038	; Analog Comparator
.equ	ADCCaddr	= 0x003a	; ADC Conversion Complete
.equ	ERDYaddr	= 0x003c	; EEPROM Ready
.equ	ICP3addr	= 0x003e	; Timer/Counter3 Capture Event
.equ	OC3Aaddr	= 0x0040	; Timer/Counter3 Compare Match A
.equ	OC3Baddr	= 0x0042	; Timer/Counter3 Compare Match B
.equ	OC3Caddr	= 0x0044	; Timer/Counter3 Compare Match C
.equ	OVF3addr	= 0x0046	; Timer/Counter3 Overflow
.equ	URXC1addr	= 0x0048	; USART1, Rx Complete
.equ	UDRE1addr	= 0x004a	; USART1 Data register Empty
.equ	UTXC1addr	= 0x004c	; USART1, Tx Complete
.equ	TWIaddr		= 0x004e	; 2-wire Serial Interface
.equ	SPMRaddr	= 0x0050	; Store Program Memory Read
.equ	ICP4addr	= 0x0052	; Timer/Counter4 Capture Event
.equ	OC4Aaddr	= 0x0054	; Timer/Counter4 Compare Match A
.equ	OC4Baddr	= 0x0056	; Timer/Counter4 Compare Match B
.equ	OC4Caddr	= 0x0058	; Timer/Counter4 Compare Match C
.equ	OVF4addr	= 0x005a	; Timer/Counter4 Overflow
.equ	ICP5addr	= 0x005c	; Timer/Counter5 Capture Event
.equ	OC5Aaddr	= 0x005e	; Timer/Counter5 Compare Match A
.equ	OC5Baddr	= 0x0060	; Timer/Counter5 Compare Match B
.equ	OC5Caddr	= 0x0062	; Timer/Counter5 Compare Match C
.equ	OVF5addr	= 0x0064	; Timer/Counter5 Overflow
.equ	URXC2addr	= 0x0066	; USART2, Rx Complete
.equ	UDRE2addr	= 0x0068	; USART2 Data register Empty
.equ	UTXC2addr	= 0x006a	; USART2, Tx Complete
.equ	URXC3addr	= 0x006c	; USART3, Rx Complete
.equ	UDRE3addr	= 0x006e	; USART3 Data register Empty
.equ	UTXC3addr	= 0x0070	; USART3, Tx Complete
***** INTERRUPT VECTORS LIST TO BE ADDED AS NECESSARY *******************************************/



;reset and interrupt vector
.org 0x00 goto atmega1280_asm_setup ; set reset vector to initialization setup

#ifdef _ATMEGA1280_INTR_ENABLE
.org URXC0addr goto uart0_Receive ; UART0 data received interrupt
.org UDRE0addr goto uart0_Empty ; UART0 data free interrupt
.org UTXC0addr goto uart0_Sent ; UART0 data sent interrupt
#endif // _ATMEGA1280_INTR_ENABLE

;route assembler to the end of interrupt vector (can be disabled to save program size)
.org INT_VECTORS_SIZE



;/////////////////////////////////////////////////////////////////////////////////////////////////
atmega1280_asm_setup:
;/////////////////////////////////////////////////////////////////////////////////////////////////
;mcu SW entry point. not optimized setting. copied from avr_attiny13x_asm.inc

    ;init stack address
    setValueRL SPH, HIGH(RAMEND)
    setValueRL SPL, LOW(RAMEND)

    ;disable interrupt
    cli

    ;set to default uart if enabled
    #ifdef _ATMEGA1280_UART_ENABLE
    rcall defaultUart
    #endif

    ;if library is using interrupt, enable globally
    #ifdef _ATMEGA1280_INTR_ENABLE
    sei
    #endif

    ;app entry point
    goto main



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// interrupt routine

#ifdef _ATMEGA1280_INTR_ENABLE

.macro atmega1280_intr_setup;(vector)
    setValueWL @0
    goto atmega1280_intr
.endm

uart0_Receive: atmega1280_intr_setup URXC0addr
uart0_Empty:   atmega1280_intr_setup UDRE0addr
uart0_Sent:    atmega1280_intr_setup UTXC0addr

atmega1280_intr:
    setValueFR var1, SREG
    push var1
    rcall intr_callback
    pop var1
    setValueRF SREG, var1
retfie

#endif // _ATMEGA1280_INTR_ENABLE



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// IO pins
;/////////////////////////////////////////////////////////////////////////////////////////////////

;map = R or H
.macro enablePullUp;(map, port_char, num)
    setBit##@0 PORT##@1, @2
.endm

.macro disablePullUp;(map, port_char, num)
    clearBit##@0 PORT##@1, @2
.endm

;set to input pull up enabled
.macro setAsInput;(map, port_char, num)
    clearBit##@0 DDR##@1, @2
    enablePullUp @0, @1, @2
.endm

;set to output low
.macro setAsOutput;(map, port_char, num)
    disablePullUp @0, @1, @2
    setBit##@0 DDR##@1, @2
    disablePullUp @0, @1, @2
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// UART FUNCTIONS
;/////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _ATMEGA1280_UART_ENABLE

#define UART_INTR_BIT 7
#define UART_WAIT_BIT 6


;default uart setting, copied from ard_mega_uart.inc
defaultUart:

    // UCSRnA = RXCn,TXCn,UDREn,FEn,DORn,UPEn,U2Xn,MPCMn
    // UCSRnB = RXCIEn,TXCIEn,UDRIEn,RXENn,TXENn,UCSZn2,RXB8n,TXB8n
    // UCSRnC = UMSELn1,UMSELn0,UPMn1,UPMn0,USBSn,UCSZn1,UCSZn0,UCPOLn
    // (refer to page 224 of ATMega1280 datasheet for speed value)

    setValueHL UCSR0A, 0b01100010 ;enable U2X0 (bit 1 = 1)
    setValueHL UCSR0B, 0b00011000 ;tx and rx enabled
    setValueHL UCSR0C, 0b00000110

    // default to maximum baudrate value:
    // (U2X0=1, 2Mbps(0), 1Mbps(1), 500Kbps(3), 250Kbps(7), 230.4Kbps(8), 115.2Kbps(16))
    // (U2X0=0, 1Mbps(0), 500Kbps(1), 250Kbps(3), 230.4Kbps(3), 115.2Kbps(8))
    // (refer to page 231 of ATMega1280 datasheet for speed value)

    setValueHL UBRR0H, 0
    setValueHL UBRR0L, 0
return



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// enable uart pin and interrupt. uart = uart number (0 - 3, to be placed in W)

.macro enableUartL;(uart)
    setValueWL @0
    rcall enableUartW
.endm

.macro enableUartF;(uart_reg)
    setValueWF @0
    rcall enableUartW
.endm

;enable RXEN, TXEN ("uart number" stored in W)
enableUartW:
    ifEquWL  0, not_enb_mega1280_uart_0
        orValueHL UCSR0B, 0b00011000
        return
    not_enb_mega1280_uart_0:

    ifEquWL  1, not_enb_mega1280_uart_1
        orValueHL UCSR1B, 0b00011000
        return
    not_enb_mega1280_uart_1:

    ifEquWL 2, not_enb_mega1280_uart_2
        orValueHL UCSR2B, 0b00011000
        return
    not_enb_mega1280_uart_2:

    ifEquWL 3, not_enb_mega1280_uart_3
        orValueHL UCSR3B, 0b00011000
    not_enb_mega1280_uart_3:
return



.macro enableUartInterruptL;(uart)
    setValueWL @0
    rcall enableUartInterruptW
.endm

.macro enableUartInterruptF;(uart_reg)
    setValueWF @0
    rcall enableUartInterruptW
.endm

;enable RXCIE, TXCIE ("uart number" stored in W)
enableUartInterruptW:
    ifEquWL 0, not_enb_intr_mega1280_uart_0
        orValueHL UCSR0B, 0b11000000
        return
    not_enb_intr_mega1280_uart_0:

    ifEquWL 1, not_enb_intr_mega1280_uart_1
        orValueHL UCSR1B, 0b11000000
        return
    not_enb_intr_mega1280_uart_1:

    ifEquWL 2, not_enb_intr_mega1280_uart_2
        orValueHL UCSR2B, 0b11000000
        return
    not_enb_intr_mega1280_uart_2:

    ifEquWL 3, not_enb_intr_mega1280_uart_3
        orValueHL UCSR3B, 0b11000000
    not_enb_intr_mega1280_uart_3:
return



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// disable uart pin and interrupt. uart = uart number (0-3, to be placed in W)

.macro disableUartL;(uart)
    setValueWL @0
    rcall disableUartW
.endm

.macro disableUartF;(uart_reg)
    setValueWF @0
    rcall disableUartW
.endm

;disable RXEN, TXEN ("uart number" stored in W)
disableUartW:
   ifEquWL 0, not_dis_mega1280_uart_0
        andValueHL UCSR0B, 0b11100111
        return
    not_dis_mega1280_uart_0:

    ifEquWL 1, not_dis_mega1280_uart_1
        andValueHL UCSR1B, 0b11100111
        return
    not_dis_mega1280_uart_1:

    ifEquWL 2, not_dis_mega1280_uart_2
        andValueHL UCSR2B, 0b11100111
        return
    not_dis_mega1280_uart_2:

    ifEquWL 3, not_dis_mega1280_uart_3
        andValueHL UCSR3B, 0b11100111
    not_dis_mega1280_uart_3:
return



.macro disableUartInterruptL;(uart)
    setValueWL @0
    rcall disableUartInterruptW
.endm

.macro disableUartInterruptF;(uart_reg)
    setValueWF @0
    rcall disableUartInterruptW
.endm

;disable RXCIE, TXCIE ("uart number" stored in W)
disableUartInterruptW:
    ifEquWL 0, not_dis_intr_mega1280_uart_0
        andValueHL UCSR0B, 0b00111111
        return
    not_dis_intr_mega1280_uart_0:

    ifEquWL 1, not_dis_intr_mega1280_uart_1
        andValueHL UCSR1B, 0b00111111
        return
    not_dis_intr_mega1280_uart_1:

    ifEquWL 2, not_dis_intr_mega1280_uart_2
        andValueHL UCSR2B, 0b00111111
        return
    not_dis_intr_mega1280_uart_2:

    ifEquWL 3, not_dis_intr_mega1280_uart_3
        andValueHL UCSR3B, 0b00111111
        return
    not_dis_intr_mega1280_uart_3:
return



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// W = uart number. return W = 0 if still transmitting, W = 1 if complete transmitting
;// to be used if UART interrupt is disabled (manual transmit pooling)

.macro isUartSentL;(uart)
    setValueWL @0
    rcall isUartSentW
.endm

.macro isUartSentF;(uart_reg)
    setValueWF @0
    rcall isUartSentW
.endm

isUartSentW:
    ifEquWL 0, not_sent_mega1280_uart_0
        ifBitSetH UCSR0A, TXC0, not_clear_mega1280_uart_0
            setBitH UCSR0A, TXC0 ; manual clearing flag
            retlw 1
        not_clear_mega1280_uart_0:
        retlw 0
    not_sent_mega1280_uart_0:

    ifEquWL 1, not_sent_mega1280_uart_1
        ifBitSetH UCSR1A, TXC1, not_clear_mega1280_uart_1
            setBitH UCSR1A, TXC1 ; manual clearing flag
            retlw 1
        not_clear_mega1280_uart_1:
        retlw 0
    not_sent_mega1280_uart_1:

    ifEquWL 2, not_sent_mega1280_uart_2
        ifBitSetH UCSR2A, TXC2, not_clear_mega1280_uart_2
            setBitH UCSR2A, TXC2 ; manual clearing flag
            retlw 1
        not_clear_mega1280_uart_2:
        retlw 0
    not_sent_mega1280_uart_2:

    ifEquWL 3, not_sent_mega1280_uart_3
        ifBitSetH UCSR3A, TXC3, not_clear_mega1280_uart_3
            setBitH UCSR3A, TXC3 ; manual clearing flag
            retlw 1
        not_clear_mega1280_uart_3:
    not_sent_mega1280_uart_3:
retlw 0



;wait until uart send completion
.macro waitUartSentL;(uart)
    setValueWL @0
    rcall waitUartSentW
.endm

.macro waitUartSentF;(uart_reg)
    setValueWF @0
    rcall waitUartSentW
.endm

waitUartSentW:
    setValueFW var1

    wait_UartSent_loop:
    setValueWF var1
    rcall isUartSentW
    skipIfOddW
    goto wait_UartSent_loop
return



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// uart sent branching

.macro skipIfUartSentW
    rcall isUartSentW
    skipIfNezW
.endm

.macro skipIfUartSentL;(uart)
    setValueWL @0
    skipIfUartSentW
.endm

.macro skipIfUartSentF;(uart_reg)
    setValueWF @0
    skipIfUartSentW
.endm



.macro ifUartSentW;(not_lbl)
    skipIfUartSentW
    goto @0
.endm

.macro ifUartSentL;(uart, not_lbl)
    setValueWL @0
    ifUartSentW @1
.endm

.macro ifUartSentF;(uart_reg, not_lbl)
    setValueWF @0
    ifUartSentW @1
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// uart = uart number to be used to send data (0 - 3)
;// val/reg = literal or register byte value to be sent to uart (to be placed in W)
;// intr = is interrupt enabled upon uart tx/rx completion
;// wait = is return only if completed uart tx/rx
;// received or to be transmitted data is stored UDR
;//
;// var1 = intr + wait + uart number
;// W = data to be sent

.macro sendUartL;(uart, val, intr, wait)
    setValueWL (@2 << UART_INTR_BIT) | (@3 << UART_WAIT_BIT) | @0
    setValueFW var1
    setValueWL @1
    rcall _sendUart
.endm

.macro sendUartF;(uart, reg, intr, wait)
    setValueWL (@2 << UART_INTR_BIT) | (@3 << UART_WAIT_BIT) | @0
    setValueFW var1
    setValueWF @1
    rcall _sendUart
.endm

.macro sendUartW;(uart, intr, wait) ; W = data to be sent
    setValueFW var2
    setValueWL (@1 << UART_INTR_BIT) | (@2 << UART_WAIT_BIT) | @0
    setValueFW var1
    setValueWF var2
    rcall _sendUart
.endm



;// send W content to uart + intr + wait
;// routine will not check for uart send completion
;// to avoid clash, call isUartSent manually

;private function
_sendUart:
    setValueFW var2
    setValueWF var1
    andValueWL 0b00000011

    ;writing to uart transmit data
    ifEquWL 0, not_send_mega1280_uart_0
        setValueHF UDR0, var2
        goto isUartInterrupt
    not_send_mega1280_uart_0:

    ifEquWL 1, not_send_mega1280_uart_1
        setValueHF UDR1, var2
        goto isUartInterrupt
    not_send_mega1280_uart_1:

    ifEquWL 2, not_send_mega1280_uart_2
        setValueHF UDR2, var2
        goto isUartInterrupt
    not_send_mega1280_uart_2:

    ifEquWL 3, not_send_mega1280_uart_3
        setValueHF UDR3, var2
    not_send_mega1280_uart_3:

    ;if uart interrupt enabled, enable interrupt and quit
    isUartInterrupt:
    skipIfBitSetF var1, UART_INTR_BIT
    goto isUartWaiting

    ;interrupt enabled
    setValueWF var1
    andValueWL 0b00000011
    rcall enableUartInterruptW
    return

    ;check if wait until completion
    isUartWaiting:
    skipIfBitSetF var1, UART_WAIT_BIT
    return

    ;wait until uart send completion
    uartWaiting:
    setValueWF var1
    andValueWL 0b00000011
    rcall waitUartSentW
return



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// W = uart number. return W = 0 if no UART receive buffer, 1 if there is UART buffer
;// to be used if UART interrupt is disabled (manual receive pooling)

.macro isUartReceivedL;(uart)
    setValueWL @0
    rcall isUartReceivedW
.endm

.macro isUartReceivedF;(uart_reg)
    setValueWF @0
    rcall isUartReceivedW
.endm

isUartReceivedW:
    ifEquWL 0, not_rcvd_mega1280_uart_0
        ifBitSetH UCSR0A, RXC0, not_rcv_mega1280_uart_0
            setBitH UCSR0A, RXC0 ; manual clearing flag
            retlw 1
        not_rcv_mega1280_uart_0:
        retlw 0
    not_rcvd_mega1280_uart_0:

    ifEquWL 1, not_rcvd_mega1280_uart_1
        ifBitSetH UCSR1A, RXC1, not_rcv_mega1280_uart_1
            setBitH UCSR1A, RXC1 ; manual clearing flag
            retlw 1
        not_rcv_mega1280_uart_1:
        retlw 0
    not_rcvd_mega1280_uart_1:

    ifEquWL 2, not_rcvd_mega1280_uart_2
        ifBitSetH UCSR2A, RXC2, not_rcv_mega1280_uart_2
            setBitH UCSR2A, RXC2 ; manual clearing flag
            retlw 1
        not_rcv_mega1280_uart_2:
        retlw 0
    not_rcvd_mega1280_uart_2:

    ifEquWL 3, not_rcvd_mega1280_uart_3
        ifBitSetH UCSR3A, RXC3, not_rcv_mega1280_uart_3
            setBitH UCSR3A, RXC3 ; manual clearing flag
            retlw 1
        not_rcv_mega1280_uart_3:
    not_rcvd_mega1280_uart_3:
retlw 0



.macro waitUartReceivedL;(uart)
    setValueWL @0
    rcall waitUartReceivedW
.endm

.macro waitUartReceivedF;(uart_reg)
    setValueWF @0
    rcall waitUartReceivedW
.endm

waitUartReceivedW:
    setValueFW var1

    waitUartReceived_loop:
    setValueWF var1
    rcall isUartReceivedW
    skipIfOddW
    goto waitUartReceived_loop
return



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// uart sent branching

.macro skipIfUartReceivedW
    rcall isUartReceivedW
    skipIfNezW
.endm

.macro skipIfUartReceivedL;(uart)
    setValueWL @0
    skipIfUartReceivedW
.endm

.macro skipIfUartReceivedF;(uart_reg)
    setValueWF @0
    skipIfUartReceivedW
.endm



.macro ifUartReceivedW;(not_lbl)
    skipIfUartReceivedW
    goto @0
.endm

.macro ifUartReceivedL;(uart, not_lbl)
    setValueWL @0
    ifUartReceivedW @1
.endm

.macro ifUartReceivedF;(uart_reg, not_lbl)
    setValueWF @0
    ifUartReceivedW @1
.endm



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// W = uart number. return W = UDRn. must make manual
;// isUartReceived call to ensure valid uart data read

.macro readUartL;(uart)
    setValueWL @0
    rcall readUartW
.endm

.macro readUartF;(uart_reg)
    setValueWF @0
    rcall readUartW
.endm

readUartW:
    ifEquWL 0, not_read_mega1280_uart_0
        setValueWH UDR0
        return
    not_read_mega1280_uart_0:

    ifEquWL 1, not_read_mega1280_uart_1
        setValueWH UDR1
        return
    not_read_mega1280_uart_1:

    ifEquWL 2, not_read_mega1280_uart_2
        setValueWH UDR2
        return
    not_read_mega1280_uart_2:

    ifEquWL 3, not_read_mega1280_uart_3
        setValueWH UDR3
    not_read_mega1280_uart_3:
return



;/////////////////////////////////////////////////////////////////////////////////////////////////
;// flushing uart

.macro flushUartL;(uart)
    setValueWL @0
    rcall flushUartW
.endm

.macro flushUartF;(uart_reg)
    setValueWF @0
    rcall flushUartW
.endm

flushUartW:
    setValueFW var1
    wait_FlushReceived_loop:
        readUartF var1
        isUartReceivedF var1
        skipIfEvenW
    goto wait_FlushReceived_loop
return

#endif // _ATMEGA1280_UART_ENABLE



#endif // AVR_ATMEGA1280_ASM_INC
